# -*- coding: utf-8 -*-

from sandbox.projects.adv_machine.common import AdvMachineDownloadOnlineResourceTask
from sandbox.projects.adv_machine.common.resources import AdvMachineDataOrderMoneyLeftCaesar


class MakeAdvMachineOrderMoneyLeftCaesar(AdvMachineDownloadOnlineResourceTask):

    """Create adv machine order_money_left_caesar resource"""

    class Requirements(AdvMachineDownloadOnlineResourceTask.Requirements):
        disk_space = 2 * 1024  # 2 GiB

    class Parameters(AdvMachineDownloadOnlineResourceTask.Parameters):
        yt_table_path = AdvMachineDownloadOnlineResourceTask.Parameters.yt_table_path(default='//home/bigb/caesar/stable/Orders')
        resource_path = AdvMachineDownloadOnlineResourceTask.Parameters.resource_path(default='order_money_left_caesar')
        mode = AdvMachineDownloadOnlineResourceTask.Parameters.mode(default='money-left')
        kill_timeout = 30 * 60  # 30 min

    def on_execute(self):
        super(MakeAdvMachineOrderMoneyLeftCaesar, self).on_execute()
        AdvMachineDataOrderMoneyLeftCaesar(
            self,
            'AdvMachine order_money_left_caesar table: {}'.format(self.Parameters.description),
            self.Parameters.resource_path,
        )
