# -*- coding: utf-8 -*-

import os
import logging

from sandbox import common

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineOrganizationsDicts


logger = logging.getLogger(__name__)


class MakeAdvMachineOrganizationsDicts(AdvMachineDownloadFromYtTask):

    """Create adv machine goals.dict resources"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/organizations')
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default='organizations')
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[(s, s) for s in AdvMachineOrganizationsDicts.release_services])

    def on_execute(self):
        os.mkdir(self.Parameters.dir_name)
        AdvMachineOrganizationsDicts(self, 'AdvMachine organizations dicts: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        super(MakeAdvMachineOrganizationsDicts, self).on_execute()

    def _get_st_message(self, resources, release_services):
        return 'Готовы новые словари организаций. Скоро будут обновлен на {}. \nАвтор кто:{}. \nТаск {}'.format(
            ', '.join(release_services),
            self.author,
            common.utils.get_task_link(self.id),
        )

    def _get_telegram_message(self, params, resources, release_services):
        return '{} чух-чух-choo-choo на {}. Покатил {} потому что {}. Таск {}'.format(
            ', '.join([str(r.type) for r in resources]),
            ', '.join(release_services),
            params['releaser'],
            params['release_comments'] or self.Parameters.description,
            common.utils.get_task_link(self.id),
            )
