# -*- coding: utf-8 -*-

import os
import logging

from sandbox import common

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineORMBase


logger = logging.getLogger(__name__)


class MakeAdvMachineORMBase(AdvMachineDownloadFromYtTask):

    """Create adv machine onsite recs base"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        folder_name = 'orm_base'
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/' + folder_name)
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default=folder_name)
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[
            (s, s) for s in AdvMachineORMBase.release_services
        ])

    def on_execute(self):
        os.mkdir(self.Parameters.dir_name)
        description = 'AdvMachine OnsiteRecsMeta base: {}'.format(self.Parameters.description)
        AdvMachineORMBase(self, description, self.Parameters.dir_name)
        super(MakeAdvMachineORMBase, self).on_execute()

    def _get_st_message(self, resources, release_services):
        return (
            'Готов новый ORM base индекс для goods-recom. '
            + 'Скоро будут обновлены на {}. \nАвтор:{}. \nТаск {}'
        ).format(
            ', '.join(release_services),
            self.author,
            common.utils.get_task_link(self.id),
        )

    def _get_telegram_message(self, params, resources, release_services):
        return '{} чух-чух на {}. Покатил {} потому что {}. Таск {}'.format(
            ', '.join([str(r.type) for r in resources]),
            ', '.join(release_services),
            params['releaser'],
            params['release_comments'] or self.Parameters.description,
            common.utils.get_task_link(self.id),
        )
