# -*- coding: utf-8 -*-

import logging
import os

from sandbox import common

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachinePagesDict


logger = logging.getLogger(__name__)


class MakeAdvMachinePagesDict(AdvMachineDownloadFromYtTask):

    """Create adv machine pages.dict resource"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/page_resource')
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default='pages_dict')
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[(s, s) for s in AdvMachinePagesDict.release_services])

    def on_execute(self):
        os.mkdir(self.Parameters.dir_name)
        AdvMachinePagesDict(self, 'AdvMachine pages.dict: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        super(MakeAdvMachinePagesDict, self).on_execute()

    def _get_st_message(self, resources, release_services):
        return 'Готов новый pages.dict. Скоро будут обновлен на {}. \nАвтор кто:{}. \nТаск {}'.format(
            ', '.join(release_services),
            self.author,
            common.utils.get_task_link(self.id),
        )

    def _get_telegram_message(self, params, resources, release_services):
        return '{} чух-чух-choo-choo на {}. Покатил {} потому что {}. Таск {}'.format(
            ', '.join([str(r.type) for r in resources]),
            ', '.join(release_services),
            params['releaser'],
            params['release_comments'] or self.Parameters.description,
            common.utils.get_task_link(self.id),
        )
