# -*- coding: utf-8 -*-

import json
import time
from sandbox import sdk2

from sandbox.projects.adv_machine.common.resources import AdvMachinePriemkaSettings


class MakeAdvMachinePriemkaSettings(sdk2.Task):

    """Create adv machine priemka settings resource"""

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024

    class Parameters(sdk2.Task.Parameters):
        description = 'Update priemka settings'
        start_downtime = sdk2.parameters.Integer('Start downtime (now=0)', default=0)
        downtime_duration = sdk2.parameters.Integer('Downtime duration in seconds (max=21600, disabled=0)', required=True)

    def on_execute(self):
        path = 'priemka_settings.json'
        data = {'StartDowntimeTimestamp': self.Parameters.start_downtime if self.Parameters.start_downtime != 0 else int(time.time()),
                'DowntimeDurationInSeconds': self.Parameters.downtime_duration}
        with open(path, 'w') as f:
            f.write('{}\n'.format(json.dumps(data, indent=4)))

        AdvMachinePriemkaSettings(self, 'AdvMachine priemka settings', path)
