# -*- coding: utf-8 -*-

import os
import logging

from sandbox import common

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineSelectionRankLinearModels


logger = logging.getLogger(__name__)


class MakeAdvMachineSelectionRankLinearModels(AdvMachineDownloadFromYtTask):

    """Create adv machine selection rank linear models resources"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/selection_rank_linear_models')
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default='lm_selection_rank')
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[('adv-machine-robot-cm-hahn', 'adv-machine-robot-cm-hahn')])

    def on_execute(self):
        os.mkdir(self.Parameters.dir_name)
        AdvMachineSelectionRankLinearModels(self, 'AdvMachine selection rank linear models: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        super(MakeAdvMachineSelectionRankLinearModels, self).on_execute()

    def _get_st_message(self, resources, release_services):
        return 'Готовы новые линейные модели (selection rank). Скоро будут обновлены на {}. \nАвтор кто:{}. \nТаск {}'.format(
            ', '.join(release_services),
            self.author,
            common.utils.get_task_link(self.id),
        )

    def _get_telegram_message(self, params, resources, release_services):
        return '{} чух-чух на {}. Покатил {} потому что {}. Таск {}'.format(
            ', '.join([str(r.type) for r in resources]),
            ', '.join(release_services),
            params['releaser'],
            params['release_comments'] or self.Parameters.description,
            common.utils.get_task_link(self.id),
        )
