# -*- coding: utf-8 -*-

import logging

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineSkipperFormulas


logger = logging.getLogger(__name__)


class MakeAdvMachineSkipperFormulas(AdvMachineDownloadFromYtTask):

    """Creates CPU formulas for skipper"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/skipper_formulas')
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default='skipper_formulas')
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[(s, s) for s in AdvMachineSkipperFormulas.release_services])

    def on_execute(self):
        AdvMachineSkipperFormulas(self, 'AdvMachineSkipperFormulas: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        super(MakeAdvMachineSkipperFormulas, self).on_execute()
