# -*- coding: utf-8 -*-

import logging

from sandbox.projects.adv_machine.common import AdvMachineDownloadFromYtTask
from sandbox.projects.adv_machine.common.resources import AdvMachineSkipperLinearModels


logger = logging.getLogger(__name__)


class MakeAdvMachineSkipperLinearModels(AdvMachineDownloadFromYtTask):

    """Creates CPU linear models for skipper"""

    class Requirements(AdvMachineDownloadFromYtTask.Requirements):
        pass

    class Parameters(AdvMachineDownloadFromYtTask.Parameters):
        yt_path = AdvMachineDownloadFromYtTask.Parameters.yt_path(default='adv_machine/skipper_lm')
        dir_name = AdvMachineDownloadFromYtTask.Parameters.dir_name(default='skipper_lm')
        release_services = AdvMachineDownloadFromYtTask.Parameters.release_services(choices=[(s, s) for s in AdvMachineSkipperLinearModels.release_services])

    def on_execute(self):
        AdvMachineSkipperLinearModels(self, 'AdvMachineSkipperLinearModels: {}'.format(self.Parameters.description), self.Parameters.dir_name)
        super(MakeAdvMachineSkipperLinearModels, self).on_execute()
