# -*- coding: utf-8 -*-

import os

from sandbox import sdk2

import sandbox.sandboxsdk.environments as sdk_environments

from sandbox.projects.adv_machine.common import pack_tables_from_yt, get_yt_config, ConfigFormat, SchemaMode
from sandbox.projects.adv_machine.common import AdvMachineReleaseTask
from sandbox.projects.adv_machine.common.resources import AdvMachineBlackListsTables
from sandbox.projects.adv_machine.common.parameters import YTParameters


def get_resource_type(resource_type_str):
    if resource_type_str == 'ADV_MACHINE_BLACK_LISTS_TABLES':
        return AdvMachineBlackListsTables
    else:
        assert False, 'Unknown resource type to create!'


class PrepareAdvMachineYtResource(AdvMachineReleaseTask):

    class Requirements(AdvMachineReleaseTask.Requirements):
        cores = 1
        environments = [
            sdk_environments.PipEnvironment('yandex-yt'),
            sdk_environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(AdvMachineReleaseTask.Parameters):
        yt_params = YTParameters

        description = sdk2.parameters.String('Description')

        with_attrs = sdk2.parameters.Bool('Store tables attributes', default=True)
        with_schema = sdk2.parameters.Bool('Store table schema', default=True)

        with sdk2.parameters.RadioGroup('Resource type to create', required=True) as resource_to_create:
            resource_to_create.values['ADV_MACHINE_BLACK_LISTS_TABLES'] = resource_to_create.Value(value='ADV_MACHINE_BLACK_LISTS_TABLES', default=True)
            resource_to_create.values['ADV_MACHINE_MARKET_VIEW_STATISTICS'] = resource_to_create.Value(value='ADV_MACHINE_MARKET_VIEW_STATISTICS')

        use_default_path = sdk2.parameters.Bool('Use default YT path', default=True)

        with use_default_path.value[False]:
            yt_path = sdk2.parameters.String('YT path to tables, table or map_node', required=True)

    def _get_yt_path(self):
        if self.Parameters.use_default_path:
            return get_resource_type(self.Parameters.resource_to_create).default_path
        else:
            return self.Parameters.yt_path

    def on_execute(self):
        from yt.wrapper import YtClient

        resource_path = 'resource'
        os.mkdir(resource_path)

        config = get_yt_config(self.Parameters.yt_params, format=ConfigFormat.CLIENT)
        yt_client = YtClient(config=config)

        yt_path = self._get_yt_path()
        schema_mode = SchemaMode.STRONG_SCHEMA if self.Parameters.with_schema else SchemaMode.WEEK_SCHEMA
        pack_tables_from_yt(yt_client, yt_path, resource_path, with_attrs=self.Parameters.with_attrs, schema_mode=schema_mode)

        get_resource_type(self.Parameters.resource_to_create)(self, self.Parameters.description, resource_path)

        super(PrepareAdvMachineYtResource, self).on_execute()
