# -*- coding: utf-8 -*-
import logging
import os

from sandbox.projects.advq.common import validate_arcadia_rev
from sandbox import sdk2
from sandbox.projects.advq.artifacts import BROADMATCH_EXPORT
from sandbox.projects.advq.common.parameters import PhitsParameters
from sandbox.common.types.task import Semaphores
from sandbox.projects.advq.common.yt_utils import get_yt_env_from_parameters
from sandbox.sdk2.resource import ResourceData
from sandbox.sdk2.helpers import subprocess as sp


SEMAPHORE_NAME_TEMPLATE = 'advq_broadmatch_export-{type}_{dbname}'
BROADMATCH_EXPORT_MIN_REV = 5009871


class AdvqBroadmatchExport(sdk2.Task):
    class Parameters(PhitsParameters):
        advq_db = sdk2.parameters.String("Database names", default='rus')
        clean = sdk2.parameters.Bool("Clean", default=True)

    def on_enqueue(self):
        # Устанавливаем семафор.
        self.Requirements.semaphores = Semaphores(
            acquires=[
                Semaphores.Acquire(name=SEMAPHORE_NAME_TEMPLATE.format(type=self.Parameters.advq_phits_type,
                                                                       dbname=self.Parameters.advq_db),
                                   capacity=1)
            ],
        )
        return super(AdvqBroadmatchExport, self).on_enqueue()

    def on_execute(self):
        validate_arcadia_rev(self.Parameters.advq_build_binaries, [BROADMATCH_EXPORT_MIN_REV])
        advq_generation_binaries_data = ResourceData(self.Parameters.advq_build_binaries)

        broadmatch_export_binary_path = str(advq_generation_binaries_data.path.joinpath(BROADMATCH_EXPORT))

        yt_env = get_yt_env_from_parameters(self.Parameters)
        env = dict(os.environ, **yt_env)

        if self.Parameters.clean:
            clean_args = ['--clean']
        else:
            clean_args = []

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("advq-broadmatch-export")) as pl:
            sp.check_call(
                [broadmatch_export_binary_path, str(self.Parameters.advq_phits_type), str(self.Parameters.advq_db)] + clean_args,
                stderr=pl.stdout, env=env)
