# -*- coding: utf-8 -*-
import shutil
from sandbox import sdk2
from sandbox.projects.advq.common import AdvqNormalChronoDatabaseChunk, AdvqLegacyNormalChronoDatabaseChunk


class AdvqLegacyChronoConverter(sdk2.Task):
    """Recreate normal chrono database resource as a legacy chrono database resource.
    Content (and thus skynet_id) and attributes remains same.  Only resource type is changed."""
    class Parameters(sdk2.Task.Parameters):
        input_res = sdk2.parameters.Resource("Single-volume database chunk to convert",
                                             resource_type=AdvqNormalChronoDatabaseChunk)

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        disk_space = 60 * 1024   # 60 GB -- largest monthly_rus is about 50GB
        ram = 256  # RAM size of my first computer

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        chrono_res_data = sdk2.ResourceData(self.Parameters.input_res)

        new_res = AdvqLegacyNormalChronoDatabaseChunk(
            self,
            description=self.Parameters.input_res.description,
            path=chrono_res_data.path.name,
            **dict(self.Parameters.input_res)
        )

        # Copy downloaded resource to home dir.
        shutil.copy2(str(chrono_res_data.path), '.')

        new_res_data = sdk2.ResourceData(new_res)
        new_res_data.ready()
