# -*- coding: utf-8 -*-
import os

import sandbox.projects.common.constants as consts
from sandbox.projects.advq.artifacts import ADVQ_BACKEND_ARTIFACTS
from sandbox.projects.resource_types import ADVQ_BINARY
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params
from sandbox.projects.common.build.parameters import get_arcadia_params


class BuildAdvqBackendBinaries(YaMakeTask):
    type = 'BUILD_ADVQ_BACKEND_BINARIES'
    descr = 'Build AdvQ binaries for backend'

    # Исключает из параметров всё то, что не следует заполнять вручную.
    input_parameters = get_arcadia_params() + ya_make_build_params()

    def get_arts(self):
        return [
            {
                'path': os.path.join(path, name),  # где будет лежать артефакт после сборки
                'dest': '',  # каталог, куда поместить артефакт относительно корня архива-ресурса
            }
            for name, path in ADVQ_BACKEND_ARTIFACTS.items()
        ]

    def get_arts_source(self):
        return []

    def get_targets(self):
        return ADVQ_BACKEND_ARTIFACTS.values()

    def get_resources(self):
        return {
            'project': {
                'description': 'AdvQ backend binaries',
                'resource_type': str(ADVQ_BINARY),
            }
        }

    def get_target_platform_flags(self):
        return self.ctx.get(consts.TARGET_PLATFORM_FLAGS) or '--target-platform=DEFAULT-LINUX-X86_64'

    def on_enqueue(self):
        YaMakeTask.on_enqueue(self)
        if not self.ctx.get(consts.DEFINITION_FLAGS_KEY):
            self.ctx[consts.DEFINITION_FLAGS_KEY] = '-DJDK_VERSION=11'
