# -*- coding: utf-8 -*-
import os

from sandbox.projects.advq.artifacts import OFFLINE_PKZ_ARTIFACTS
from sandbox.projects.advq.common import OfflinePkzBinaries
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params
from sandbox.projects.common.build.parameters import get_arcadia_params


class BuildOfflinePkzBinaries(YaMakeTask):
    type = 'BUILD_OFFLINE_PKZ_BINARIES'
    descr = 'Build binaries for offline-pkz'

    # Исключает из параметров всё то, что не следует заполнять вручную.
    input_parameters = get_arcadia_params() + ya_make_build_params()

    def get_arts(self):
        return [
            {
                'path': os.path.join(path, name),  # где будет лежать артефакт после сборки
                'dest': '',  # каталог, куда поместить артефакт относительно корня архива-ресурса
            }
            for name, path in OFFLINE_PKZ_ARTIFACTS.items()
        ]

    def get_arts_source(self):
        return []

    def get_targets(self):
        return OFFLINE_PKZ_ARTIFACTS.values()

    def get_resources(self):
        return {
            'project': {
                'description': 'Artifacts for offline-phits',
                'resource_type': str(OfflinePkzBinaries),
            }
        }
