# -*- coding: utf-8 -*-
import os

from sandbox.projects.advq.artifacts import POKAZOMETER_GENERATION_ARTIFACTS
from sandbox.projects.advq.common import PokazometerGenerationBinaries
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params
from sandbox.projects.common.build.parameters import get_arcadia_params


class BuildPokazometerGenerationBinaries(YaMakeTask):
    type = 'BUILD_POKAZOMETER_GENERATION_BINARIES'
    descr = 'Build Pokazometer binaries for generating different indices, YT tables, etc.'

    # Исключает из параметров всё то, что не следует заполнять вручную.
    input_parameters = get_arcadia_params() + ya_make_build_params()

    def get_arts(self):
        return [
            {
                'path': os.path.join(path, name),  # где будет лежать артефакт после сборки
                'dest': '',  # каталог, куда поместить артефакт относительно корня архива-ресурса
            }
            for name, path in POKAZOMETER_GENERATION_ARTIFACTS.items()
        ]

    def get_arts_source(self):
        return []

    def get_targets(self):
        return POKAZOMETER_GENERATION_ARTIFACTS.values()

    def get_resources(self):
        return {
            'project': {
                'description': 'Pokazometer binaries for generating different indices, YT tables, etc.',
                'resource_type': PokazometerGenerationBinaries.name,
            }
        }
