import requests

DEFAULT_UNIWORD_URL = 'http://bssoap.yandex.ru:81/export/export-table.cgi?table_name=Uniword'


def get_words(url):
    req = requests.get(url)
    req.raise_for_status()
    data = req.json()

    for rec in data:
        options = rec.get("Options", "").split(',')

        if 'stop' in options:
                yield rec['Data']


def main():  # for manual testing
    print '\n'.join(sorted(get_words(DEFAULT_UNIWORD_URL))).encode('utf-8')


if __name__ == '__main__':
    main()
