# -*- coding: utf-8 -*-
import os

import sandbox.projects.common.constants as consts
from sandbox.projects.advq.artifacts import OFFLINE_PHITS_ARTIFACTS
from sandbox.projects.advq.common import OfflinePhitsArtifacts
from sandbox.projects.common.build.YaMake import YaMakeTask, ya_make_build_params
from sandbox.projects.common.build.parameters import get_arcadia_params


class BuildOfflinePhitsArtifacts(YaMakeTask):
    type = 'BUILD_OFFLINE_PHITS_ARTIFACTS'
    descr = 'Build artifacts for offline-phits'

    # Исключает из параметров всё то, что не следует заполнять вручную.
    input_parameters = get_arcadia_params() + ya_make_build_params()

    def get_arts(self):
        return [
            {
                'path': os.path.join(path, name),  # где будет лежать артефакт после сборки
                'dest': '',  # каталог, куда поместить артефакт относительно корня архива-ресурса
            }
            for name, path in OFFLINE_PHITS_ARTIFACTS.items()
        ]

    def get_arts_source(self):
        return []

    def get_targets(self):
        return OFFLINE_PHITS_ARTIFACTS.values()

    def get_resources(self):
        return {
            'project': {
                'description': 'Artifacts for offline-phits',
                'resource_type': OfflinePhitsArtifacts.name,
            }
        }

    def on_enqueue(self):
        YaMakeTask.on_enqueue(self)
        if not self.ctx.get(consts.DEFINITION_FLAGS_KEY):
            self.ctx[consts.DEFINITION_FLAGS_KEY] = '-DJDK_VERSION=11'
