# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sdk2.resource import ResourceData

from sandbox.projects.advq.common.parameters import YtParameters
from sandbox.projects.advq.common.yt_utils import get_yt_env_from_parameters
from sandbox.projects.advq.artifacts import OFFLINE_PHITS_MONITORING
from sandbox.projects.advq.common import (
    # OfflinePhitsArtifacts,
    validate_arcadia_rev,
    YT_MINIMAL_REV
)


class OfflinePhitsMonitoring(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        disk_space = 128
        ram = 128

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(YtParameters):
        artifacts = sdk2.parameters.LastReleasedResource(
            "offline-phits artifacts",
            # type=OfflinePhitsArtifacts,  # FIXME: invalid argument (SANDBOX-6404)
            required=True
        )
        url = sdk2.parameters.String("solomon url", required=True)
        dbs_path = sdk2.parameters.String("ypath to directory with databases", required=True)
        export_path = sdk2.parameters.String("ypath to offline phits export table", required=True)
        yav_secret_id = sdk2.parameters.YavSecret("YAV secret id", required=True,
                                                       description='secret should contain keys: solomon',
                                                       default='sec-01eggmyedjg4hcbtcrrd5j1dxg')

    def on_execute(self):
        env = get_yt_env_from_parameters(self.Parameters)

        validate_arcadia_rev(self.Parameters.artifacts, [YT_MINIMAL_REV])

        artifacts_data = ResourceData(self.Parameters.artifacts)
        binary_path = str(artifacts_data.path.joinpath(OFFLINE_PHITS_MONITORING))
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("offline-phits-monitoring")) as pl:
            sp.check_call(
                [
                    binary_path, self.Parameters.url, self.Parameters.dbs_path, self.Parameters.export_path, self.Parameters.yav_secret_id.data()["solomon"]
                ],
                stderr=pl.stdout, env=env)
