# -*- coding: utf-8 -*-
# pylint: disable=invalid-name
# pylint: disable=missing-docstring
# pylint: disable=too-few-public-methods
"""
Genereate and clean //home/advq/advq/adnetevents tables for Pokazometer.
"""
import logging
import os

import sandbox.common.types.client as ctc
from sandbox import sdk2
from sandbox.common.types.task import Semaphores
from sandbox.projects.advq.common import PokazometerGenerationBinaries
from sandbox.projects.advq.artifacts import POKAZOMETER_GENERATE_EVENTS
from sandbox.projects.advq.common.parameters import YtParameters
from sandbox.projects.advq.common.yt_utils import get_yt_yql_env_from_parameters

SEMAPHORE_NAME_TEMPLATE = 'AdvqPokazometerGenAdnetevents'


class PokazometerGenAdnetevents(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.IPV6
        cores = 1
        disk_space = 256  # Minimum disk space in MiB

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        pokazometer_gen_binaries = sdk2.parameters.Resource(
            "Pokazometer genreation resource", resource_type=PokazometerGenerationBinaries)
        yt = YtParameters
        yql_token_vault_user = sdk2.parameters.String("YQL key vault owner")
        yql_token_vault_name = sdk2.parameters.String("YQL key vault name")

    def on_enqueue(self):
        self.Requirements.semaphores = Semaphores(
            acquires=[
                Semaphores.Acquire(
                    name=SEMAPHORE_NAME_TEMPLATE,
                    capacity=1),
            ],
        )

    def on_execute(self):
        binaries = sdk2.ResourceData(self.Parameters.pokazometer_gen_binaries)

        args = [
            str(binaries.path.joinpath(POKAZOMETER_GENERATE_EVENTS))
        ]
        env = dict(os.environ)
        env.update(get_yt_yql_env_from_parameters(self.Parameters))

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger(__name__)) as pl:
            sdk2.helpers.subprocess.check_call(args, env=env, stdout=pl.stdout, stderr=pl.stderr)
