# -*- coding: utf-8 -*-
ADVQ_OLD_API_BACKEND = 'advq-old-api'
FORECAST_API_BACKEND = 'forecast-api'

ADVQ_DATATEST_TOOL = 'advq_datatest_tool'
ADVQ_PHITS_ANTIFRAUD = 'advq_phits_antifraud'
ADVQ_PHITS_DB_GENERATOR = 'advq_phits_db_generator'
ADVQ_STATS_CONFIG_GENERATOR = 'advq_stats_config_generator'
FORECAST_CONFIG_GENERATOR = 'forecast_config_generator'
ADVQ_SUMHITS_CLEANER = 'advq_sumhits_cleaner'
ADVQ_PHITS_INDEX_UPLOADER = 'advq_phits_index_uploader'
ASSOC_GENERATOR = 'assoc_generator'
BROADMATCH_EXPORT = 'broadmatch_export'
CHRONO_DB_GENERATOR = 'chrono_db_generator'
HITLOG_GENERATOR = 'hitlog_generator'
HITLOG_FROM_CHHIT_GENERATOR = 'hitlog_from_chhit_generator'
MRKIT_LEGACY_READER = 'mrkit_legacy_reader'
PHITS_GENERATOR = 'phits_generator'
SANDBOX_GROUPER = 'sandbox_grouper'

SUMHITS_GENERATOR = 'sumhits_generator'
ADVQ_SUMHITS_FROM_PHITS = 'advq_sumhits_from_phits'
ADVQ_SUMHITS_DB_GENERATOR = 'advq_sumhits_db_generator'
ADVQ_SUMHITS_MERGE_HITS = 'advq_sumhits_merge_hits'
ADVQ_DELAY_MONITORING_JAR = 'tools-search-index-delay-monitoring.jar'

OFFLINE_PHITS_EXPORT = 'direct_export'
OFFLINE_PHITS_UTIL = 'offline_phits_util.jar'
OFFLINE_PHITS_MONITORING = 'monitoring'
OFFLINE_PHITS_UPLOAD = 'upload'

OFFLINE_PKZ_MAIN = 'offline_pkz_main'
OFFLINE_PKZ_PROCESS = 'offline_pkz_process'

POKAZOMETER_BUILD_DB = 'build_db'
POKAZOMETER_CLICK_GENERATOR = 'click_generator'
POKAZOMETER_GENERATE_EVENTS = 'generate_events'
POKAZOMETER_SHOW_GENERATOR = 'show_generator'

PKZ_GENERATOR = 'pkz_generator'
PKZ_DB_GENERATOR = 'advq_pkz_db_generator'

"""
Список всех утилит, которые могут использоваться для сборки индексов, YT-таблиц, etc.

Ключ - имя файла для утилиты, которая будет сгенерирована.
Значение - путь из корня аркадии до каталога с ya.make, который генерирует утилиту с названием <ключ>.
"""
ADVQ_GENERATION_ARTIFACTS = {
    ADVQ_DATATEST_TOOL: 'advq/generation/advq_datatest_tool',
    ADVQ_PHITS_ANTIFRAUD: 'advq/generation/phits_antifraud',
    ADVQ_PHITS_DB_GENERATOR: 'advq/generation/phits_db_generator',
    ADVQ_STATS_CONFIG_GENERATOR: 'advq/generation/advq_stats_config_generator',
    FORECAST_CONFIG_GENERATOR: 'advq/generation/forecast_config_generator',
    ADVQ_SUMHITS_CLEANER: 'advq/generation/sumhits_cleaner',
    ADVQ_PHITS_INDEX_UPLOADER: 'advq/generation/phits_index_uploader',
    ASSOC_GENERATOR: 'advq/generation/assoc_generator',
    BROADMATCH_EXPORT: 'advq/generation/broadmatch_export/bin',
    CHRONO_DB_GENERATOR: 'advq/generation/chrono_db_generator',
    HITLOG_GENERATOR: 'advq/generation/hitlog_generator',
    HITLOG_FROM_CHHIT_GENERATOR: 'advq/generation/hitlog_from_chhit_generator',
    MRKIT_LEGACY_READER: 'advq/generation/mrkit_legacy_reader',
    PHITS_GENERATOR: 'advq/generation/phits_generator',
    SANDBOX_GROUPER: 'advq/generation/sandbox_grouper',
    PKZ_GENERATOR: 'advq/generation/pkz_generator/bin',
    PKZ_DB_GENERATOR: 'advq/generation/pkz_db_generator/bin',

    SUMHITS_GENERATOR: 'advq/generation/sumhits_generator',
    ADVQ_SUMHITS_FROM_PHITS: 'advq/generation/sumhits_from_phits',
    ADVQ_SUMHITS_DB_GENERATOR: 'advq/generation/sumhits_db_generator',
    ADVQ_SUMHITS_MERGE_HITS: 'advq/generation/sumhits_merge_hits',

    ADVQ_DELAY_MONITORING_JAR: 'advq/java/tools/search-index-delay-monitoring',
}

"""
AdvQ backend.
"""
ADVQ_BACKEND_ARTIFACTS = {
    ADVQ_OLD_API_BACKEND: 'advq/java/apps/old-api',
}

"""
Forecast backend.
"""
FORECAST_BACKEND_ARTIFACTS = {
    FORECAST_API_BACKEND: 'advq/java/apps/forecast-api',
}

"""
Список артефактов offline-phits
"""
OFFLINE_PHITS_ARTIFACTS = {
    OFFLINE_PHITS_EXPORT: 'advq/offline_phits/direct_export',
    OFFLINE_PHITS_UTIL: 'advq/offline_phits/java',
    OFFLINE_PHITS_MONITORING: 'advq/offline_phits/monitoring',
    OFFLINE_PHITS_UPLOAD: 'advq/offline_phits/upload'
}

"""
Список артефактов offline-pkz
"""
OFFLINE_PKZ_ARTIFACTS = {
    OFFLINE_PKZ_MAIN: 'advq/offline_pkz/offline_pkz_main',
    OFFLINE_PKZ_PROCESS: 'advq/offline_pkz/offline_pkz_process',
}


"""
Список артефактов генерации pokazometer.
"""
POKAZOMETER_GENERATION_ARTIFACTS = {
    POKAZOMETER_BUILD_DB: 'advq/pokazometer/generation/build_db',
    POKAZOMETER_CLICK_GENERATOR: 'advq/pokazometer/generation/click_generator',
    POKAZOMETER_GENERATE_EVENTS: 'advq/pokazometer/generation/generate_events',
    POKAZOMETER_SHOW_GENERATOR: 'advq/pokazometer/generation/show_generator',
}
