# -*- coding: utf-8 -*-
from sandbox.projects.advq.common.parameters import get_secret_from_vault


def get_sandbox_env_from_parameters(parameters):
    """Создаем словарь с переменными окружения для программ, которые используют Sandbox

    SANDBOX_TOKEN берется из Sandbox vault, если parameters.sandbox_token_vault_name
    не пуст (parameters.sandbox_token_vault_user может быть пустым).

    :param parameters: sdk2.Task.Parameters с установленными полями sandbox_token_vault_user, sandbox_token_vault_name
    :return: словарь с переменными окружения
    :rtype dict
    """
    sandbox_token = get_secret_from_vault('sandbox', parameters)
    env = {}
    if sandbox_token:
        env['SANDBOX_TOKEN'] = sandbox_token
    return env
