# -*- coding: utf-8 -*-
from sandbox import sdk2


def get_yql_env_from_parameters(parameters):
    """
    Создаем словарь с перенными окружения для запуска программ, использующих YQL

    YQL_PROXY берётся из parameters.yql_proxy. YQL_TOKEN берётся из Sandbox vault, если parameters.yql_token_vault_name
    не пуст (parameters.yql_token_vault_user может быть пустым).

    :param parameters: sdk2.Task.Parameters с установленными полями yql_proxy, yql_token_vault_name
    :return: словарь с переменными окружения
    :rtype dict
    """

    yql_proxy = parameters.yql_proxy
    yql_token_vault_user = parameters.yql_token_vault_user
    yql_token_vault_name = parameters.yql_token_vault_name

    env = {
        'YQL_PROXY': yql_proxy
    }
    if yql_token_vault_name:
        if yql_token_vault_user:
            token = sdk2.Vault.data(yql_token_vault_user, yql_token_vault_name)
        else:
            token = sdk2.Vault.data(yql_token_vault_name)
        env['YQL_TOKEN'] = token

    return env
