# -*- coding: utf-8 -*-
from sandbox import sdk2


def get_yt_env_from_parameters(parameters):
    """
    Создаём словарь с переменными окружения для запуска программ, которые испольуют YT.

    YT_PROXY берётся из parameters.yt_proxy.  YT_TOKEN берётся из Sandbox vault, если parameters.yt_token_vault_name
    не пуст (parameters.yt_token_vault_user может быть пустым).

    :param parameters: sdk2.Task.Parameters с установленными полями yt_proxy, yt_token_vault_user, yt_token_vault_name
    :return: словарь с переменными окружения
    :rtype dict
    """
    env = {
        'YT_PROXY': parameters.yt_proxy
    }
    if parameters.yt_token_vault_name:
        if parameters.yt_token_vault_user:
            token = sdk2.Vault.data(parameters.yt_token_vault_user, parameters.yt_token_vault_name)
        else:
            token = sdk2.Vault.data(parameters.yt_token_vault_name)
        env['YT_TOKEN'] = str(token)
    return env


def get_yt_yql_env_from_parameters(parameters):
    """
    Создаём словарь с переменными окружения для запуска программ, которые испольуют YT и YQL.

    YT_PROXY и YQL_PROXY берётся из parameters.yt_proxy. YT_TOKEN берётся из Sandbox vault, если parameters.yt_token_vault_name
    не пуст (parameters.yt_token_vault_user может быть пустым). YQL_TOKEN берётся из Sandbox vault, если parameters.yql_token_vault_name
    не пуст (parameters.yql_token_vault_user может быть пустым).

    :param parameters: sdk2.Task.Parameters с установленными полями yt_proxy, yt_token_vault_user, yt_token_vault_name,
    yql_token_vault_user, yql_token_vault_name
    :return: словарь с переменными окружения
    :rtype dict
    """
    env = {
        'YT_PROXY': parameters.yt_proxy,
        'YQL_PROXY': parameters.yt_proxy
    }

    if parameters.yt_token_vault_name:
        if parameters.yt_token_vault_user:
            token = sdk2.Vault.data(parameters.yt_token_vault_user, parameters.yt_token_vault_name)
        else:
            token = sdk2.Vault.data(parameters.yt_token_vault_name)
        env['YT_TOKEN'] = str(token)

    if parameters.yql_token_vault_name:
        if parameters.yql_token_vault_user:
            token = sdk2.Vault.data(parameters.yql_token_vault_user, parameters.yql_token_vault_name)
        else:
            token = sdk2.Vault.data(parameters.yql_token_vault_name)
        env['YQL_TOKEN'] = str(token)

    return env


def setup_yt_from_parameters(parameters):
    """
    Конфигурируем yt.wrapper.config из значений Parameters.

    Proxy берётся из parameters.yt_proxy.  Token берётся из Sandbox vault, если parameters.yt_token_vault_name
    не пуст (parameters.yt_token_vault_user может быть пустым).

    :param parameters: sdk2.Task.Parameters с установленными полями yt_proxy, yt_token_vault_user, yt_token_vault_name
    :return: словарь с переменными окружения
    :rtype dict
    """
    import yt.wrapper as yt
    yt.config['proxy']['url'] = parameters.yt_proxy
    if parameters.yt_token_vault_name:
        if parameters.yt_token_vault_user:
            token = sdk2.Vault.data(parameters.yt_token_vault_user, parameters.yt_token_vault_name)
        else:
            token = sdk2.Vault.data(parameters.yt_token_vault_name)
        yt.config['token'] = str(token)


def make_yt_client(parameters):
    """
    :param parameters: .parameters.YtParameters
    :rtype: yt.wrapper.YtClient
    """
    from yt.wrapper import YtClient
    token = None
    if parameters.yt_token_vault_name:
        if parameters.yt_token_vault_user:
            token = sdk2.Vault.data(parameters.yt_token_vault_user, parameters.yt_token_vault_name)
        else:
            token = sdk2.Vault.data(parameters.yt_token_vault_name)
    return YtClient(proxy=parameters.yt_proxy, token=token)
