# -*- coding: utf-8 -*-
from sandbox import sdk2

__all__ = [
    "AgencyCabinetGateway",
    "AgencyCabinetRewards",
    "AgencyCabinetClientBonuses",
    "AgencyCabinetGrants",
    "AgencyCabinetRabbitmq",
    "AgencyCabinetAgencies",
    "AgencyCabinetGatewayInternal",
    "AgencyCabinetCertificates",
    "AgencyCabinetDocuments",
    "AgencyCabinetORD"
]

_alpaca_subgroup = ["sivakov512", "pconstant", "amstir", "dmitryeremin", "kachcoder"]

_agency_cabinet_releasers = ["coderfly", "danielbord", "kishmar", "robot-agency-cabinet", "sbalzitova"] + _alpaca_subgroup


class AgencyCabinetGateway(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetRewards(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetClientBonuses(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetGrants(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetRabbitmq(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetAgencies(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetGatewayInternal(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetGatewayExternal(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetCertificates(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetDocuments(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers


class AgencyCabinetORD(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = _agency_cabinet_releasers
