# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.resource_types import search_priemka_releasers


class AgencyRewardsDeb(sdk2.Resource):
    """
        Agency Rewards deb package resource
    """
    any_arch = False
    releasable = True
    releasers = search_priemka_releasers + ["robot-testenv", "robot-srch-releaser"]
    auto_backup = True
    arcadia_build_path = 'billing/agency_rewards'


class AgencyRewardsLbDeb(AgencyRewardsDeb):
    """
        Agency Rewards LiquiBase (LB) deb package resource
    """
    pass
