# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.projects.vins.common.resources import VinsPackage
from sandbox.projects.alice_evo.common.const import EvoConstants
from sandbox.projects.alice_evo.common.nanny import NannyToolbox
from sandbox.projects.alice_evo.common.misc import MiscToolbox

logger = logging.getLogger(__name__)


class AliceEvoCheckpointFast(sdk2.Task):
    """
        Fast checkpoint for Alice Evo tests in trunk
    """

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 600  # 10 min
        evo_in_origin = sdk2.parameters.String(
            "evo_in_origin",
            required=True,
            default="default"
        )
        evo_in_trunk_revision = sdk2.parameters.String(
            "evo_in_trunk_revision",
            required=True,
            default="0"
        )
        with sdk2.parameters.Output:
            evo_out_trunk_revision = sdk2.parameters.String(
                "evo_out_trunk_revision"
            )
            evo_out_current_prod_vins_package = sdk2.parameters.Resource(
                "evo_out_current_prod_vins_package",
                resource_type=VinsPackage
            )
            evo_out_trunk_id = sdk2.parameters.String(
                "evo_out_trunk_id"
            )
            evo_out_trunk_st_ticket = sdk2.parameters.String(
                "evo_out_trunk_st_ticket"
            )
            evo_out_trunk_sandbox_svn_path = sdk2.parameters.String(
                "evo_out_trunk_sandbox_svn_path_with_revision"
            )
            evo_out_trunk_sandbox_svn_path_with_revision = sdk2.parameters.String(
                "evo_out_trunk_sandbox_svn_path_with_revision"
            )

    def on_execute(self):
        logger.info("[INFO] Start task")

        self.Parameters.evo_out_trunk_revision = \
            self.Parameters.evo_in_trunk_revision

        self.Parameters.evo_out_trunk_id = \
            MiscToolbox.get_trunk_id(self.Parameters.evo_out_trunk_revision)

        self.Parameters.evo_out_trunk_st_ticket = \
            EvoConstants.TRUNK_ST_TICKET

        self.Parameters.evo_out_current_prod_vins_package = \
            NannyToolbox.get_prod_vins_package()

        self.Parameters.evo_out_trunk_sandbox_svn_path = \
            EvoConstants.TRUNK_SANDBOX_SVN_PATH

        self.Parameters.evo_out_trunk_sandbox_svn_path_with_revision = \
            self.Parameters.evo_out_trunk_sandbox_svn_path + "@" + self.Parameters.evo_out_trunk_revision

        logger.info("[INFO] Finish task")
