# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.projects.vins.common.resources import VinsPackage

logger = logging.getLogger(__name__)


class AliceEvoCheckpointPackage(sdk2.Task):
    """
        Package checkpoint for Alice Evo tests in trunk
    """

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 600  # 10 min
        evo_in_origin = sdk2.parameters.String(
            "evo_in_origin",
            required=True,
            default="default"
        )
        evo_in_trunk_vins_package = sdk2.parameters.Resource(
            "evo_in_trunk_vins_package",
            resource_type=VinsPackage
        )
        with sdk2.parameters.Output:
            evo_out_trunk_vins_package = sdk2.parameters.Resource(
                "evo_out_trunk_vins_package",
                resource_type=VinsPackage
            )

    def on_execute(self):
        logger.info("[INFO] Start task")

        self.Parameters.evo_out_trunk_vins_package = \
            self.Parameters.evo_in_trunk_vins_package

        logger.info("[INFO] Finish task")
