# -*- coding: utf-8 -*-

import logging

from sandbox.projects.vins.common.resources import VinsPackage

from sandbox import sdk2


logger = logging.getLogger(__name__)


class AliceEvoContextPackage(sdk2.Task):
    '''
        Context with vins package for Alice Evo tests in release machine
    '''

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 600  # 10 min
        evo_in_vins_package = sdk2.parameters.Resource(
            'evo_in_vins_package',
            resource_type=VinsPackage,
            required=True
        )
        with sdk2.parameters.Output:
            evo_out_vins_package = sdk2.parameters.Resource(
                'evo_out_vins_package',
                resource_type=VinsPackage
            )

    def on_execute(self):
        logger.info("[INFO] Start task")
        self.Parameters.evo_out_vins_package = \
            self.Parameters.evo_in_vins_package
        logger.info("[INFO] Finish task")
