# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox.projects.alice_evo.common.const import AccessTokens
from sandbox.projects.alice_evo.common.yappy import YappyToolbox

logger = logging.getLogger(__name__)


class AliceEvoContextService(sdk2.Task):
    '''
        Context with beta service for Alice Evo tests in release machine
    '''

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 600  # 10 min
        evo_in_branch_num = sdk2.parameters.String(
            'evo_in_branch_num',
            required=True
        )
        evo_in_tag_num = sdk2.parameters.String(
            'evo_in_tag_num',
            required=True
        )
        with sdk2.parameters.Output:
            evo_out_beta_name = sdk2.parameters.String(
                'evo_out_beta_name'
            )
            evo_out_megamind_url = sdk2.parameters.String(
                'evo_out_megamind_url'
            )
            evo_out_yappy_page = sdk2.parameters.String(
                'evo_out_yappy_page'
            )

    def on_execute(self):
        logger.info("[INFO] Start task")
        beta_prefix = "megamindvinsbass-hamster"

        beta_name = YappyToolbox.get_beta_name(
            beta_prefix,
            self.Parameters.evo_in_branch_num,
            self.Parameters.evo_in_tag_num
        )
        self.Parameters.evo_out_beta_name = beta_name

        yappy_token = sdk2.Vault.data(AccessTokens.YAPPY_TOKEN_OWNER, AccessTokens.YAPPY_TOKEN_NAME)

        beta_url = YappyToolbox.get_megamind_speechkit_app_pa_url(
            beta_prefix,
            self.Parameters.evo_in_branch_num,
            self.Parameters.evo_in_tag_num
        )

        self.Context.evo_ctx_megamind_url = beta_url
        self.Parameters.evo_out_megamind_url = beta_url

        self.Parameters.evo_out_yappy_page = YappyToolbox.get_yappy_page(
            beta_prefix,
            self.Parameters.evo_in_branch_num,
            self.Parameters.evo_in_tag_num
        )

        logger.info("[INFO] Finish task")
