# -*- coding: utf-8 -*-

import logging

import sandbox.projects.common.build.parameters as build_params
from sandbox import sdk2
from sandbox.projects.alice_evo.common.const import RequirementsConstants
from sandbox.projects.common.build.tasks import YaMakeTemplate

logger = logging.getLogger(__name__)


class AliceVoiceCommands(sdk2.Resource):
    releasable = True
    any_arch = True
    releasers = ['mihajlova']
    auto_backup = True
    share = True


class AliceIntegrationTests(sdk2.Resource):
    releasable = False
    any_arch = True
    releasers = None
    auto_backup = False
    share = False
    arcadia_build_path = 'alice/tests/integration_tests'


class AliceEvoIntegrationTests(YaMakeTemplate.YaMakeTemplate):
    """
        Build and run Alice EVO integration tests
    """

    class Requirements(sdk2.Task.Requirements):
        client_tags = RequirementsConstants.CLIENT_TAGS
        cores = 1
        ram = 24 * 1024

        # disable all caches by default (make it multislot-aware)
        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(YaMakeTemplate.get_project_params([AliceIntegrationTests])):
        env_vars = build_params.EnvironmentVarsParam(default_value='YAV_TOKEN=\'$(vault:value:mihajlova:yav-alice-integration-tests-token)\'')

        test = build_params.TestParameter(default_value=True)
        test_params = build_params.TestCustomParameters(default_value='uniproxy-url=wss://beta.uniproxy.alice.yandex.net/alice-uniproxy-hamster/uni.ws')
