# -*- coding: utf-8 -*-

import sandbox.projects.common.build.parameters as build_params
from sandbox import sdk2
from sandbox.projects.alice_evo.common.const import RequirementsConstants
from sandbox.projects.common.build.tasks import YaMakeTemplate


class AliceMarkerTests(sdk2.Resource):
    releasable = False
    any_arch = True
    releasers = None
    auto_backup = False
    share = False
    arcadia_build_path = 'alice/tests/marker_tests'


class AliceEvoMarkerTests(YaMakeTemplate.YaMakeTemplate):
    """
        Build and run Alice EVO marker tests
    """

    class Requirements(sdk2.Task.Requirements):
        client_tags = RequirementsConstants.CLIENT_TAGS

        cores = 4
        ram = 24 * 1024

        # disable all caches by default (make it multislot-aware)
        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(YaMakeTemplate.get_project_params([AliceMarkerTests])):
        env_vars = build_params.EnvironmentVarsParam(default_value='YAV_TOKEN=\'$(vault:value:mihajlova:yav-alice-integration-tests-token)\'')

        test = build_params.TestParameter(default_value=True)
        test_params = build_params.TestCustomParameters(default_value='uniproxy-url=wss://beta.uniproxy.alice.yandex.net/alice-uniproxy-hamster/uni.ws')
