from sandbox import sdk2

from sandbox.projects.vins.common.resources import (VinsPackage,
                                                    MegamindHelperBinaries,
                                                    MegamindRequests,
                                                    MegamindShooterBinary)


class AliceEvoPerfDummy(sdk2.Task):
    """ Dummy task to imitate MegamindComparePerformanceBeta """

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('Packages') as packages_parameters:
            old_vins_package = sdk2.parameters.Resource('Old VINS package', resource_type=VinsPackage, required=True)
            new_vins_package = sdk2.parameters.Resource('New VINS package', resource_type=VinsPackage, required=True)
            megamind_requests = sdk2.parameters.Resource('Megamind requests', resource_type=MegamindRequests,
                                                         required=True)
            shooter_binary = sdk2.parameters.Resource('Megamind shooter resource', resource_type=MegamindShooterBinary,
                                                      required=True)
            perf_differ_binary = sdk2.parameters.Resource('Megamind perf differ resource',
                                                          resource_type=MegamindHelperBinaries, required=True)

        with sdk2.parameters.Group('Secrets') as secrets_parameters:
            bass_vault_owner = sdk2.parameters.String('BASS vault owner', default='BASS', required=True)
            bass_vault_name = sdk2.parameters.String('BASS vault name', default='robot-bassist_vault_token',
                                                     required=True)
            test_user_vault_owner = sdk2.parameters.String('Test User vault owner', default='BASS', required=True)
            test_user_vault_name = sdk2.parameters.String('Test User vault name', default='alice-diff-test-token',
                                                          required=True)

        with sdk2.parameters.Group('Config') as config_parameters:
            # non-YDB config
            handwritten_config = sdk2.parameters.JSON('Handwritten config to use')

            # config from YDB
            ydb_token_vault_owner = sdk2.parameters.String('YDB Token vault owner', default='BASS')
            ydb_token_vault_name = sdk2.parameters.String('YDB Token vault name', default='robot_bassist_ydb_token')
            config_endpoint = sdk2.parameters.String('Config YDB endpoint', default='ydb-ru.yandex.net:2135')
            config_database = sdk2.parameters.String('Config YDB database', default='/ru/home/sparkle/mydb')
            config_table = sdk2.parameters.String('Config YDB table', default='configs')
            config_id = sdk2.parameters.String('Config YDB id in table', default='comp_perf')

        with sdk2.parameters.Group('Misc') as misc_parameters:
            joker_semaphore_name = sdk2.parameters.String('Joker semaphore name', default='JOKER_CONNECTIONS')
            diff_time = sdk2.parameters.Float('Average delta enough for diff', default=0.015)

        kill_timeout = 5 * 60  # 5 minutes

    def on_execute(self):
        pass
