# -*- coding: utf-8 -*-

import logging

from sandbox.projects.alice_evo.common.const import EvoConstants
from sandbox.projects.alice_evo.common.nirvana import NirvanaToolbox
from sandbox import sdk2
import sandbox.sandboxsdk.environments as sdk_environments

logger = logging.getLogger(__name__)


class AliceEvoUE2E(sdk2.Task):
    """
        Launch UE2E for Alice releases
    """

    class Requirements(sdk2.Task.Requirements):
        environments = [sdk_environments.PipEnvironment('startrek_client', version='2.3.0', custom_parameters=['--upgrade-strategy only-if-needed']), ]

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 600  # 10 min
        component_name = sdk2.parameters.String(
            'component_name',
            required=True,
            default=EvoConstants.VINS_RM_NAME
        )
        branch_num = sdk2.parameters.String(
            'branch_num',
            required=True,
            default="0"
        )
        tag_num = sdk2.parameters.String(
            'tag_num',
            required=True,
            default="0"
        )
        first_tag_num = sdk2.parameters.String(
            'first_tag_num',
            required=False,
            default="1",
        )
        evo_in_is_trunk = sdk2.parameters.Bool(
            'evo_in_is_trunk',
            required=True,
            default=False
        )
        evo_in_trunk_revision = sdk2.parameters.String(
            'evo_in_trunk_revision',
            required=True,
            default="0"
        )
        megamind_url = sdk2.parameters.String(
            'megamind_url',
            required=True,
            default=EvoConstants.MEGAMIND_HAMSTER_URL
        )
        uniproxy_url = sdk2.parameters.String(
            'uniproxy_url',
            required=True,
            default=EvoConstants.UNIPROXY_HAMSTER_URL
        )
        abc_id = sdk2.parameters.Integer(
            'abc_id',
            required=True,
            default=23708
        )
        test_experiments = sdk2.parameters.List(
            'list of experiments for megamind url',
            required=True,
            default=[]
        )
        force_start = sdk2.parameters.Bool(
            'force_start',
            required=True,
            default=False
        )
        release_ticket = sdk2.parameters.String(
            'release_ticket',
            required=True,
            default='ALICERELEASE-1'
        )
        st_append_mode = sdk2.parameters.Bool(
            'st_append_mode',
            required=True,
            default=True
        )
        app_type = sdk2.parameters.String(
            'app_type',
            required=True,
            default='all'
        )
        fast_run = sdk2.parameters.Bool(
            'fast_run',
            required=True,
            default=False
        )
        yt_tables_ttl = sdk2.parameters.Integer(
            'yt_tables_ttl',
            required=False,
            default=14,
        )

        baskets = sdk2.parameters.List(
            'list of baskets',
            required=True,
            default=[
                'ue2e_quasar',
                'ue2e_general',
                'ue2e_navi_auto',
                'ue2e_quasar_from_online',
                'e2e_fairytale',
                'e2e_quasar_facts',
                'e2e_quasar_item_selector',
                'e2e_quasar_sinsig_music',
                'ue2e_tv',
                'e2e_quasar_alarms',
            ]
        )

        with sdk2.parameters.RadioGroup("web_search_request_mode") as web_search_request_mode:
            web_search_request_mode.values["0"] = web_search_request_mode.Value("cache_put", default=True)
            web_search_request_mode.values["1"] = web_search_request_mode.Value("cache_lookup")

        with sdk2.parameters.Output:
            nirvana_instance_url = sdk2.parameters.String(
                'nirvana_instance_url'
            )

    def on_execute(self):
        logger.info("START")
        self.Parameters.nirvana_instance_url = NirvanaToolbox.handle_nirvana_launch(
            component_name=self.Parameters.component_name,
            megamind_url=self.Parameters.megamind_url,
            abc_id=self.Parameters.abc_id,
            branch_num=self.Parameters.branch_num,
            tag_num=self.Parameters.tag_num,
            test_experiments=self.Parameters.test_experiments,
            force_start=self.Parameters.force_start,
            st_append_mode=self.Parameters.st_append_mode,
            release_ticket=self.Parameters.release_ticket,
            is_trunk=self.Parameters.evo_in_is_trunk,
            trunk_revision=self.Parameters.evo_in_trunk_revision,
            uniproxy_url=self.Parameters.uniproxy_url,
            app_type=self.Parameters.app_type,
            fast_run=self.Parameters.fast_run,
            yt_tables_ttl=self.Parameters.yt_tables_ttl,
            web_search_request_mode=self.Parameters.web_search_request_mode,
            baskets=self.Parameters.baskets,
            first_tag_num=self.Parameters.first_tag_num,
        )
        logger.info("FINISH")
