# -*- coding: utf-8 -*-

import logging

from sandbox.projects.alice_evo.common.const import EvoConstants
from sandbox.projects.alice_evo.common.nirvana import NirvanaToolbox
from sandbox import sdk2
import sandbox.sandboxsdk.environments as sdk_environments

logger = logging.getLogger(__name__)


class AliceEvoValidateUE2E(sdk2.Task):
    """
        Launch UE2E for vareleases
    """

    class Requirements(sdk2.Task.Requirements):
        environments = [sdk_environments.PipEnvironment('startrek_client', version='2.3.0', custom_parameters=['--upgrade-strategy only-if-needed']), ]

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 600  # 10 min

        release_ticket = sdk2.parameters.String(
            'release_ticket',
            required=True,
            default='VARELEASE-1'
        )
        target_instance_to_clone = sdk2.parameters.String(
            'target_instance_to_clone',
            required=True,
            default='84c3db39-5318-4c65-8988-a2b5a4956aab'
        )
        start_clonned_instance = sdk2.parameters.Bool(
            'start_clonned_instance',
            required=True,
            default=False
        )

        with sdk2.parameters.Output:
            nirvana_instance_url = sdk2.parameters.String(
                'nirvana_instance_url'
            )

    def on_execute(self):
        logger.info("START")
        self.Parameters.nirvana_instance_url = NirvanaToolbox.handle_nirvana_launch(
            component_name=EvoConstants.VINS_RM_NAME,  # component_name,
            megamind_url=EvoConstants.MEGAMIND_HAMSTER_URL,  # megamind_url,
            abc_id=23708,  # abc_id,
            branch_num="0",  # branch_num,
            tag_num="0",  # tag_num,
            test_experiments=[],  # test_experiments,
            force_start=self.Parameters.start_clonned_instance,
            st_append_mode=True,  # st_append_mode,
            release_ticket=self.Parameters.release_ticket,
            is_trunk=False,  # evo_in_is_trunk,
            trunk_revision="0",  # evo_in_trunk_revision
            varelease_mode=True,  # varelease_mode
            target_instance=self.Parameters.target_instance_to_clone,
            uniproxy_url=EvoConstants.UNIPROXY_HAMSTER_URL,
            app_type="all",
            fast_run=False,
            baskets=[
                'ue2e_quasar',
                'ue2e_general',
                'ue2e_navi_auto',
                'ue2e_quasar_from_online',
                'e2e_fairytale',
                'e2e_quasar_facts',
                'e2e_quasar_item_selector',
                'e2e_quasar_sinsig_music',
                'ue2e_tv',
                'e2e_quasar_alarms',
            ]
        )
        logger.info("FINISH")
