import sandbox.common.types.client as ctc
from sandbox.common.types.misc import DnsType


class AccessTokens(object):
    BASS_VAULT_TOKEN_NAME = 'robot-bassist_vault_token'
    BASS_VAULT_TOKEN_OWNER = 'BASS'

    NANNY_TOKEN_NAME = 'robot-bassist_nanny_token'
    NANNY_TOKEN_OWNER = 'VINS'

    NIRVANA_PRIEMKINS_TOKEN_ENV = 'ALICE_EVO_NIRVANA_PRIEMKINS_TOKEN_ENV'
    NIRVANA_PRIEMKINS_TOKEN_NAME = 'robot-alice-priemka_nirvana_token'
    NIRVANA_PRIEMKINS_TOKEN_OWNER = 'VINS'

    PULSAR_PRIEMKINS_TOKEN_NAME = 'robot-alice-priemka-pulsar-token'

    NIRVANA_TOKEN_ENV = 'ALICE_EVO_NIRVANA_TOKEN_ENV'
    NIRVANA_TOKEN_NAME = 'robot_bassist_nirvana_oauth_token'
    NIRVANA_TOKEN_OWNER = 'BASS'

    STATFACE_TOKEN_ENV = 'ALICE_EVO_STATFACE_TOKEN_ENV'
    STATFACE_TOKEN_NAME = 'robot-bassist_statface_token'
    STATFACE_TOKEN_OWNER = 'VINS'

    ST_TOKEN_ENV = 'ALICE_EVO_ST_TOKEN_ENV'
    ST_TOKEN_NAME = 'robot_bassist_startrek_oauth_token'
    ST_TOKEN_OWNER = 'BASS'
    ST_USERAGENT = 'robot-bassist'

    TESTPALM_TOKEN_ENV = 'ALICE_EVO_TESTPALM_TOKEN_ENV'
    TESTPALM_TOKEN_NAME = 'env.TESTPALM_OAUTH_TOKEN'
    TESTPALM_TOKEN_OWNER = 'WONDERLAND'

    YAPPY_TOKEN_NAME = "robot-bassist_yappy_token"
    YAPPY_TOKEN_OWNER = "BASS"


class AnalyticsInfoConstants(object):
    ST_COMMENT_TITLE = "Alice EVO AnalyticsInfo"


class EvoConstants(object):
    # The id of BMV release machine
    VINS_RM_NAME = 'vins'

    # The id of Begemot Megamind release machine
    BEGEMOT_MEGAMIND_RM_NAME = 'begemot_megamind'

    # The id of AliceApphost release machine
    ALICE_GRAPHS_RM_NAME = 'alice_graphs'

    # The id of HollywoodCommon release machine
    HOLLYWOOD_COMMON_RM_NAME = 'hollywood'

    # The id of HollywoodGeneralConversation release machine
    HOLLYWOOD_GENERAL_CONVERSATION_RM_NAME = 'hollywood_general_conversation'

    # The id of HollywoodGoodwin release machine
    HOLLYWOOD_GOODWIN_RM_NAME = 'hollywood_goodwin'

    # The id of Uniproxy release machine
    UNIPROXY_RM_NAME = 'uniproxy'

    # The id of voice_graphs release machine (apphost graphs for Uniproxy)
    VOICE_GRAPHS_RM_NAME = 'voice_graphs'

    # The id of IoT release machine
    IOT_RM_NAME = 'bulbasaur'

    # The id of ASR release machine
    ASR_RM_NAME = 'asr_server'

    # The id of videobass release machine
    VIDEOBASS_RM_NAME = 'videobass'

    PLACEHOLDER_ST_TICKET = "ALICERELEASE-1"

    # Startrek ticket to validate vins-trunk
    TRUNK_ST_TICKET = "ALICEINFRA-588"
    TRUNK_SANDBOX_SVN_PATH = "arcadia:/arc/trunk/arcadia"

    MEGAMIND_HAMSTER_URL = "http://vins.hamster.alice.yandex.net/speechkit/app/pa/"

    UNIPROXY_HAMSTER_URL = "wss://beta.uniproxy.alice.yandex.net/alice-uniproxy-hamster/uni.ws"


class LegacyConstants(object):
    LEGACY_DESCRIPTION = "LEGACY"

    PA_TOOLS_TEST_NAME = 'run_integration_diff_tests'

    EXPERIMENTS = '"mm_dont_defer_apply:1"'
    PLACEHOLDERS = '"city_dialog_id:672f7477-d3f0-443d-9bd5-2487ab0b6a4c"'
    RETRIES = "3"

    ST_COMMENT_TITLE = 'Alice EVO Legacy Test'


class NirvanaConstants(object):
    # No ETALON_UE2E_INSTANCE because since ALICEINFRA-372 switched to main instance
    ETALON_UE2E_WORKFLOW = "aa47f60a-570f-48d5-a5a1-aa8faa6c03dc"

    TARGET_UE2E_WORKFLOW = "55486b5d-1b54-4a72-882f-36c4aef3a1bf"

    TOKEN_ARCANUM_BASSIST = "robot-bassist_arcanum_token"
    TOKEN_YQL_BASSIST = "robot-bassist_yql_token"
    TOKEN_YT_BASSIST = "robot-bassist_yt_token"

    TOKEN_ARCANUM_PRIEMKINS = "robot-alice-priemka_arcanum_token"
    TOKEN_YQL_PRIEMKINS = "robot-alice-priemka_yql_token"
    TOKEN_YT_PRIEMKINS = "robot-alice-priemka_yt_token"

    RESULTS_DIRECTORY = "//home/${global.mr_account}/ue2e/${meta.owner}/nirvana"
    RANDOM_POSTFIX_LENGTH = 5

    ST_COMMENT_TITLE = "Alice EVO UE2E"

    NIRVANA_API = "https://nirvana.yandex-team.ru/api/public/v1/"
    NEW_QUOTA_PROJECT_ID = "voice-core"
    MEGAMIND_NEW_QUOTA_PROJECT_ID = "alice-acceptance"


class PerfConstants(object):
    PERF_DESCRIPTION = "PERF"

    DUMMY_TASK = "ALICE_EVO_PERF_DUMMY"
    REAL_TASK = "MEGAMIND_COMPARE_PERFORMANCE_BETA"
    OUTPUT_RESOURCE = "MEGAMIND_PERFORMANCE_DIFF"

    MEGAMIND_REQUESTS = 1547082558
    SHOOTER_BINARY = 1865843262
    PERF_DIFFER_BINARY = 1597276946
    JOKER_SEMAPHORE_NAME = ""

    ST_COMMENT_TITLE = "Alice EVO Perf Test"


class RequirementsConstants(object):
    CLIENT_TAGS = ctc.Tag.SSD & ctc.Tag.Group.LINUX & \
        (ctc.Tag.INTEL_E5_2650 | ctc.Tag.INTEL_E5_2660 | ctc.Tag.INTEL_E5_2660V1 | ctc.Tag.INTEL_E5_2660V4) & \
        ~ctc.Tag.LINUX_LUCID
    CORES = 16
    DNS = DnsType.DNS64
    DISK_SPACE = 250000
    RAM = 64 * 1024
    PRIVILEGED = False
