import logging
import json
import requests

logger = logging.getLogger(__name__)


class GistToolbox(object):
    @staticmethod
    def post_diff(diff_id, diff_text):
        # {
        #   "description": "Hello World Examples",
        #   "public": false,
        #   "files": {
        #     "hello_world.rb": {
        #       "content": "class HelloWorld\n   def initialize(name)\n"
        #     }
        #   }
        # }
        post_data = {
            "description": diff_id,
            "public": False,
            "files": {
                diff_id: {
                    "content": diff_text
                }
            }
        }
        post_data_json = json.dumps(post_data)
        res = requests.post(url='https://github.yandex-team.ru/api/v3/gists',
                            data=post_data_json)

        logger.info(str(res.status_code))
        if res.status_code == 201:  # 201 - CREATED
            res_content = res.json()
            logger.info(res_content)
            return res_content["html_url"]

        return None
