from datetime import datetime

from sandbox.projects.alice_evo.common.const import EvoConstants
from sandbox.projects.alice_evo.common.sandbox import SandboxToolbox


class MiscToolbox(object):
    @staticmethod
    def get_release_id(branch_num, tag_num, component_name=EvoConstants.VINS_RM_NAME):
        """
        Get vins release id
        e.g.: "vins-45-6"

        """

        return MiscToolbox.get_component_release_id(
            component_name,
            branch_num,
            tag_num
        )

    @staticmethod
    def get_component_release_id(component_name, branch_num, tag_num):
        """
        Get component release id
        e.g.: "vins-45-6", "hollywood-20-1"

        """

        return "{}-{}-{}".format(
            component_name,
            branch_num,
            tag_num
        )

    @staticmethod
    def get_trunk_id(trunk_revision, component_name=EvoConstants.VINS_RM_NAME):
        """
        Get trunk id
        e.g.: "vins-r123456"

        """

        return "{}-r{}".format(
            component_name,
            trunk_revision
        )

    @staticmethod
    def get_smart_run_id(old_package_resource_id, new_package_resource_id, old_is_prod, test_kind):
        """
        Get smart run id
        e.g.: "[PERF] (prod) vins-r6905601.stable-50-11.692643254 vs vins-r6971286.trunk.700181504 at 2020-06-17 00:39:16"

        """

        old_package_version = SandboxToolbox.get_vins_package_resource_version(old_package_resource_id)
        new_package_version = SandboxToolbox.get_vins_package_resource_version(new_package_resource_id)

        smart_run_id = \
            "vins-r" + \
            old_package_version + \
            " vs " + \
            "vins-r" + \
            new_package_version

        if old_is_prod:
            smart_run_id = "(prod) " + smart_run_id

        smart_run_id = \
            "[" + test_kind + "] " + \
            smart_run_id + \
            " at " + datetime.today().strftime("%Y-%m-%d %H:%M:%S")

        return smart_run_id
