import logging
import requests

from sandbox import sdk2
from sandbox.projects.alice_evo.common.const import AccessTokens
from sandbox.projects.alice_evo.common.vault import VaultToolbox
from sandbox.projects.vins.common.resources import VinsPackage

logger = logging.getLogger(__name__)


class NannyToolbox(object):
    @staticmethod
    def get_nanny_token():
        return VaultToolbox.get_token_from_env_or_vault(
            AccessTokens.NANNY_TOKEN_OWNER,
            AccessTokens.NANNY_TOKEN_NAME
        )

    @staticmethod
    def get_prod_vins_package():
        nanny_token = NannyToolbox.get_nanny_token()
        r = requests.get(
            'http://nanny.yandex-team.ru/v2/services/megamind_hamster/active/runtime_attrs/',
            headers={
                'Content-Type': 'application/json',
                'Authorization': 'OAuth {}'.format(nanny_token)
            }
        )
        if not r.raise_for_status():
            logger.info('[INFO] Data from Nanny received')

            for res in r.json()['content']['resources']['sandbox_files']:
                logger.info('[INFO] Check sandbox files in nanny serive')

                if res['resource_type'] == 'VINS_PACKAGE':
                    logger.info('[INFO] VINS_PACKAGE in prod service found')
                    logger.info(res['resource_id'])
                    return sdk2.Resource.find(type=VinsPackage,
                                              id=res['resource_id']).first()
