import logging

from sandbox.projects.alice_evo.common.startrek import StartrekToolbox
from sandbox.projects.release_machine.components import all as rmc
from sandbox.projects.release_machine.helpers.startrek_helper import STHelper

logger = logging.getLogger(__name__)


class ReleaseMachineToolbox(object):
    @staticmethod
    def get_release_ticket_for_branch(rm_name, branch_num):
        """
            Get release ticket by branch number
            e.g.: for branch "45" release ticket is "ALICERELEASE-897"
        """

        st_token = StartrekToolbox.get_startrek_token()
        component_name = rm_name
        # ticket like ALICERELEASE-1
        st_helper = STHelper(st_token)
        c_info = rmc.COMPONENTS[component_name]()
        release_ticket = \
            st_helper.find_ticket_by_release_number(branch_num, c_info).key
        return release_ticket

    @staticmethod
    def get_last_release_info(rm_name, resource):
        """
            Get sdk2.Resouce
            e.g.: major_release_num, minor_release_num
        """
        c_info = rmc.COMPONENTS[rm_name]()

        return c_info.get_release_numbers_from_attrs(resource)
