from sandbox.sandboxsdk.channel import channel


class SandboxToolbox(object):
    @staticmethod
    def get_sandbox_task_url(task_id):
        """
        Get URL to Sandbox Task
        e.g.: "https://sandbox.yandex-team.ru/task/289063783"

        """

        return "https://sandbox.yandex-team.ru/task/" + task_id

    @staticmethod
    def get_sandbox_resource_url(resource_id):
        """
        Get URL to Sandbox Resource folder
        e.g.: "https://proxy.sandbox.yandex-team.ru/289063783"

        """

        return "https://proxy.sandbox.yandex-team.ru/" + resource_id

    @staticmethod
    def get_vins_package_resource_version(resource_id):
        """
        Get VinsPackage resource_version
        e.g.: "6905601.stable-50-11.692643254", "6971286.trunk.700181504"

        """

        return channel.sandbox.get_resource_attribute(resource_id,
                                                      'resource_version')
