from sandbox.projects.alice_evo.common.const import EvoConstants


class SvnToolbox(object):
    @staticmethod
    def get_branch_path(branch_num, component_name):
        """
        Get arcadia branch path
        e.g.: "/arc/branches/vins/vins-40/arcadia"

        """

        if component_name == EvoConstants.ALICE_GRAPHS_RM_NAME:
            return '/arc/branches/apphost/conf/alice/stable-{}/arcadia'.format(
                branch_num
            )

        return '/arc/branches/{}/{}-{}/arcadia'.format(
            EvoConstants.VINS_RM_NAME,
            EvoConstants.VINS_RM_NAME,
            branch_num
        )

    @staticmethod
    def get_branch_svn_ssh_url(branch_num, component_name):
        """
        Get svn+ssh arcadia branch path
        e.g.: "svn+ssh://arcadia.yandex.ru/arc/branches/vins/vins-40/arcadia"

        """

        return "svn+ssh://arcadia.yandex.ru" + \
            SvnToolbox.get_branch_path(branch_num, component_name)

    @staticmethod
    def get_tag_path(branch_num, tag_num, component_name):
        """
        Get arcadia tag path
        e.g.: "/arc/tags/vins/stable-41-15/arcadia"

        """

        if component_name == EvoConstants.ALICE_GRAPHS_RM_NAME:
            return '/arc/tags/apphost/conf/alice/stable-{}-{}/arcadia'.format(
                branch_num,
                tag_num
            )

        return '/arc/tags/{}/stable-{}-{}/arcadia'.format(
            EvoConstants.VINS_RM_NAME,
            branch_num,
            tag_num
        )

    @staticmethod
    def get_tag_svn_ssh_url(branch_num, tag_num, component_name):
        """
        Get svn+ssh arcadia tag path
        e.g.: "svn+ssh://arcadia.yandex.ru/arc/tags/vins/stable-41-15/arcadia"

        """

        return "svn+ssh://arcadia.yandex.ru" + \
            SvnToolbox.get_tag_path(branch_num, tag_num, component_name)

    @staticmethod
    def get_tag_sandbox_svn_path(branch_num, tag_num, component_name):
        """
        Get sandbox-like arcadia tag path
        e.g.: "arcadia:/arc/tags/vins/stable-41-14/arcadia"

        """

        return "arcadia:" + \
            SvnToolbox.get_tag_path(branch_num, tag_num, component_name)
