import logging
import os

from sandbox import sdk2

logger = logging.getLogger(__name__)


class VaultToolbox(object):
    @staticmethod
    def get_token_from_env_or_vault(token_owner,
                                    token_name,
                                    token_env=None):
        """
        Get token from ENV or from Vault
        ENV has the first priority

        """

        logger.info('[INFO] get_token_from_env_or_vault')
        if (token_env is not None) and (token_env in os.environ):
            logger.info('[INFO] Get token from ENV')
            return os.environ[token_env]

        logger.info('[INFO] Get token from Vault')
        return sdk2.Vault.data(
            token_owner,
            token_name)
