import requests


class YappyToolbox(object):
    @staticmethod
    def get_beta_name(beta_prefix, branch_num, tag_num):
        """
        Generate Yappy Beta Name
        e.g.: "alice-megamind-rc-42-12"

        """

        beta_name = \
            "{beta_prefix}-{branch_num}-{tag_num}".format(
                beta_prefix=beta_prefix,
                branch_num=branch_num,
                tag_num=tag_num
            )
        return beta_name

    @staticmethod
    def get_megamind_speechkit_app_pa_url(beta_prefix, branch_num, tag_num):
        """
        Generate Yappy URL
        e.g.: "http://alice-megamind-rc-42-12.yappy.beta.yandex.ru/speechkit/app/pa/"

        """

        prefix = "http://" + \
            YappyToolbox.get_beta_name(beta_prefix, branch_num, tag_num)
        return prefix + ".yappy.beta.yandex.ru/speechkit/app/pa/"

    @staticmethod
    def get_begemot_megamind_wizard_url(beta_prefix, branch_num, tag_num):
        """
        Generate Yappy URL
        e.g.: "http://begemot-megamind-64-3.yappy.beta.yandex.ru/wizard/"

        """

        prefix = "http://" + \
            YappyToolbox.get_beta_name(beta_prefix, branch_num, tag_num)
        return prefix + ".yappy.beta.yandex.ru/wizard/"

    @staticmethod
    def get_yappy_page(beta_prefix, branch_num, tag_num):
        """
        Generate Yappy Page URL
        e.g.: "https://yappy.z.yandex-team.ru/b/alice-megamind-rc-46-11"

        """

        return "https://yappy.z.yandex-team.ru/b/" + \
            YappyToolbox.get_beta_name(beta_prefix, branch_num, tag_num)

    @staticmethod
    def get_beta_name_by_vins_id(vins_id):
        """
        Generate Yappy Beta Name
        e.g.: "alice-megamind-rc-vins-r123456"

        """

        beta_name = \
            "alice-megamind-rc-{vins_id}".format(
                vins_id=vins_id
            )
        return beta_name

    @staticmethod
    def get_megamind_speechkit_app_pa_url_by_vins_id(vins_id):
        """
        Generate Yappy URL
        e.g.: "http://alice-megamind-rc-vins-r123456.yappy.beta.yandex.ru/speechkit/app/pa/"

        """

        prefix = "http://" + \
                 YappyToolbox.get_beta_name_by_vins_id(vins_id)
        return prefix + ".yappy.beta.yandex.ru/speechkit/app/pa/"

    @staticmethod
    def get_yappy_page_by_vins_id(vins_id):
        """
        Generate Yappy Page URL
        e.g.: "https://yappy.z.yandex-team.ru/b/alice-megamind-rc-vins-r123456"

        """

        return "https://yappy.z.yandex-team.ru/b/" + \
            YappyToolbox.get_beta_name_by_vins_id(vins_id)

    @staticmethod
    def add_yappy_page_prefix(yappy_beta_id):
        """
        Generate Yappy Page URL
        e.g.: "https://yappy.z.yandex-team.ru/b/alice-megamind-rc-vins-r123456"

        """

        return "https://yappy.z.yandex-team.ru/b/" + yappy_beta_id

    @staticmethod
    def get_yappy_slots(yappy_name, yappy_token, yappy_type):
        r = requests.post(
            "https://yappy.z.yandex-team.ru/api/yappy.services.Model/retrieveBetasSlots",
            headers={
                "Content-Type": "application/json",
                "Authorization": "OAuth {}".format(yappy_token)
            },
            json={
                "betas_regexps": yappy_name,
                "allocated": True
            }
        )
        if not r.raise_for_status():
            for beta in r.json()["betaSlots"]:
                if beta["betaName"] == yappy_name:
                    hosts = beta["typeToSlots"][yappy_type]["hosts"]
                    return hosts
            return []
