import unittest

from sandbox.projects.alice_evo.common.const import EvoConstants
from sandbox.projects.alice_evo.common.misc import MiscToolbox


class YappyToolboxTests(unittest.TestCase):
    expected_release_id = "vins-45-6"

    def test_get_release_id(self):
        self.assertEqual(
            MiscToolbox.get_release_id("45", "6"),
            self.expected_release_id)

    def test_get_component_release_id(self):
        self.assertEqual(
            MiscToolbox.get_component_release_id(EvoConstants.VINS_RM_NAME, "45", "6"),
            self.expected_release_id)

        self.assertEqual(
            MiscToolbox.get_component_release_id(EvoConstants.VINS_RM_NAME, 45, 6),
            self.expected_release_id)

        self.assertEqual(
            MiscToolbox.get_component_release_id(EvoConstants.VINS_RM_NAME, "45", 6),
            self.expected_release_id)

        self.assertEqual(
            MiscToolbox.get_component_release_id(EvoConstants.VINS_RM_NAME, 45, "6"),
            self.expected_release_id)

        self.assertEqual(
            MiscToolbox.get_component_release_id("hollywood", "20", "1"),
            "hollywood-20-1")

    def test_get_trunk_id(self):
        self.assertEqual(
            MiscToolbox.get_trunk_id("123456"),
            "vins-r123456")


if __name__ == '__main__':
    unittest.main()
