import unittest

from sandbox.projects.alice_evo.common.const import (EvoConstants,
                                                     NirvanaConstants)
from sandbox.projects.alice_evo.common.nirvana import NirvanaToolbox


class NirvanaToolboxTests(unittest.TestCase):
    def test_get_token_name(self):
        arcanum_token = "arcanum_token"
        yql_token = "yql_token"
        yt_token = "yt_token"

        unknown_token = "unknown_token"

        unknown_service = "unknown_service"

        empty_result = ""

        # For main service
        self.assertEqual(
            NirvanaToolbox.get_token_name(unknown_token, EvoConstants.VINS_RM_NAME),
            empty_result
        )
        self.assertEqual(
            NirvanaToolbox.get_token_name(arcanum_token, EvoConstants.VINS_RM_NAME),
            empty_result
        )
        self.assertEqual(
            NirvanaToolbox.get_token_name(yql_token, EvoConstants.VINS_RM_NAME),
            NirvanaConstants.TOKEN_YQL_PRIEMKINS
        )
        self.assertEqual(
            NirvanaToolbox.get_token_name(yt_token, EvoConstants.VINS_RM_NAME),
            empty_result
        )

        # For other services
        self.assertEqual(
            NirvanaToolbox.get_token_name(unknown_token, unknown_service),
            empty_result
        )
        self.assertEqual(
            NirvanaToolbox.get_token_name(arcanum_token, unknown_service),
            empty_result
        )
        self.assertEqual(
            NirvanaToolbox.get_token_name(yql_token, unknown_service),
            NirvanaConstants.TOKEN_YQL_BASSIST
        )
        self.assertEqual(
            NirvanaToolbox.get_token_name(yt_token, unknown_service),
            empty_result
        )

    def test_get_yt_directory_suffix(self):
        generated_suffix_one = NirvanaToolbox._get_yt_directory_suffix(
            "vins-54-2"
        )

        generated_suffix_two = NirvanaToolbox._get_yt_directory_suffix(
            "vins-54-2"
        )

        exptected_start_non_st = "_vins-54-2_"

        self.assertTrue(
            generated_suffix_one.startswith(exptected_start_non_st)
        )

        self.assertTrue(
            generated_suffix_two.startswith(exptected_start_non_st)
        )

        self.assertEqual(
            len(generated_suffix_one),
            len(exptected_start_non_st) + NirvanaConstants.RANDOM_POSTFIX_LENGTH
        )

        self.assertEqual(
            len(generated_suffix_two),
            len(exptected_start_non_st) + NirvanaConstants.RANDOM_POSTFIX_LENGTH
        )

        generated_suffix_three = NirvanaToolbox._get_yt_directory_suffix(
            "alicerelease-123",
        )

        exptected_start_st = "_alicerelease-123_"

        self.assertTrue(
            generated_suffix_three.startswith(exptected_start_st)
        )

        self.assertEqual(
            len(generated_suffix_three),
            len(exptected_start_st) + NirvanaConstants.RANDOM_POSTFIX_LENGTH
        )


if __name__ == '__main__':
    unittest.main()
