import unittest

from sandbox.projects.alice_evo.common.svn import SvnToolbox


class SvnToolboxTests(unittest.TestCase):
    def test_get_branch_path(self):
        self.assertEqual(
            SvnToolbox.get_branch_path(40, "vins"),
            "/arc/branches/vins/vins-40/arcadia")

    def test_get_branch_svn_ssh_url(self):
        self.assertEqual(
            SvnToolbox.get_branch_svn_ssh_url(40, "vins"),
            "svn+ssh://arcadia.yandex.ru/arc/branches/vins/vins-40/arcadia")

    def test_get_tag_path(self):
        self.assertEqual(
            SvnToolbox.get_tag_path(41, 15, "vins"),
            "/arc/tags/vins/stable-41-15/arcadia")

    def test_get_tag_svn_ssh_url(self):
        self.assertEqual(
            SvnToolbox.get_tag_svn_ssh_url(41, 15, "vins"),
            "svn+ssh://arcadia.yandex.ru/arc/tags/vins/stable-41-15/arcadia")

    def test_get_tag_sandbox_svn_path(self):
        self.assertEqual(
            SvnToolbox.get_tag_sandbox_svn_path(41, 14, "vins"),
            "arcadia:/arc/tags/vins/stable-41-14/arcadia")


if __name__ == '__main__':
    unittest.main()
