import unittest

from sandbox.projects.alice_evo.common.yappy import YappyToolbox


class YappyToolboxTests(unittest.TestCase):
    def test_get_beta_name(self):
        self.assertEqual(
            YappyToolbox.get_beta_name("alice-megamind-rc", 2, 1),
            "alice-megamind-rc-2-1")

    def test_get_megamind_speechkit_app_pa_url(self):
        self.assertEqual(
            YappyToolbox.get_megamind_speechkit_app_pa_url("alice-megamind-rc", 2, 1),
            "http://alice-megamind-rc-2-1.yappy.beta.yandex.ru/speechkit/app/pa/")

    def test_get_yappy_page(self):
        self.assertEqual(
            YappyToolbox.get_yappy_page("alice-megamind-rc", 46, 11),
            "https://yappy.z.yandex-team.ru/b/alice-megamind-rc-46-11")

    def test_get_beta_name_by_vins_id(self):
        self.assertEqual(
            YappyToolbox.get_beta_name_by_vins_id("vins-r123456"),
            "alice-megamind-rc-vins-r123456")

    def test_get_megamind_speechkit_app_pa_url_by_vins_id(self):
        self.assertEqual(
            YappyToolbox.get_megamind_speechkit_app_pa_url_by_vins_id("vins-r234567"),
            "http://alice-megamind-rc-vins-r234567.yappy.beta.yandex.ru/speechkit/app/pa/")

    def test_get_yappy_page_by_vins_id(self):
        self.assertEqual(
            YappyToolbox.get_yappy_page_by_vins_id("vins-r345678"),
            "https://yappy.z.yandex-team.ru/b/alice-megamind-rc-vins-r345678")

    def test_add_yappy_page_prefix(self):
        self.assertEqual(
            YappyToolbox.add_yappy_page_prefix("alice-megamind-rc-vins-r345678"),
            "https://yappy.z.yandex-team.ru/b/alice-megamind-rc-vins-r345678")


if __name__ == '__main__':
    unittest.main()
