# -*- coding: utf-8 -*-

from sandbox.projects.alisa_skills_rec.common.resources import ALISA_SKILLS_REC_BIN, ALISA_SKILLS_REC_BSTR,\
    ALISA_SKILLS_REC_BSTR_RESOURCE_LOADER, ALISA_SKILLS_REC_RESOURSE_TAR_CALLBACK, ALISA_SKILLS_REC_CONFIGS
from sandbox.projects.common.build.KosherYaMake import KosherYaMake


class BuildAlisaSkillsRecPackage(KosherYaMake):

    class Parameters(KosherYaMake.Parameters):
        ya_make_project_params = None  # remove this params as we build specific targets

    server_target_path = 'dj/services/alisa_skills/server'
    bstr_target_path = 'tools/bstr'
    bstr_resource_loader_target_path = 'dj/tools/resource_loaders/resource_bstr_loader'
    resource_tar_callback_target_path = 'dj/tools/resource_loaders/resource_tar_callback'

    def get_targets(self):
        return [
            self.server_target_path,
            self.bstr_target_path,
            self.bstr_resource_loader_target_path,
            self.resource_tar_callback_target_path,
        ]

    def get_resources(self):
        return {
            ALISA_SKILLS_REC_BIN.name: {
                'description': ALISA_SKILLS_REC_BIN.name,
                'resource_type': ALISA_SKILLS_REC_BIN,
                'resource_path': 'dj_as_server'
            },
            ALISA_SKILLS_REC_BSTR.name: {
                'description': ALISA_SKILLS_REC_BSTR.name,
                'resource_type': ALISA_SKILLS_REC_BSTR,
                'resource_path': 'bstr'
            },
            ALISA_SKILLS_REC_BSTR_RESOURCE_LOADER.name: {
                'description': ALISA_SKILLS_REC_BSTR_RESOURCE_LOADER.name,
                'resource_type': ALISA_SKILLS_REC_BSTR_RESOURCE_LOADER,
                'resource_path': 'resource_bstr_loader'
            },
            ALISA_SKILLS_REC_RESOURSE_TAR_CALLBACK.name: {
                'description': ALISA_SKILLS_REC_RESOURSE_TAR_CALLBACK.name,
                'resource_type': ALISA_SKILLS_REC_RESOURSE_TAR_CALLBACK,
                'resource_path': 'resource_tar_callback'
            },
            ALISA_SKILLS_REC_CONFIGS.name: {
                'description': ALISA_SKILLS_REC_CONFIGS.name,
                'resource_type': ALISA_SKILLS_REC_CONFIGS,
                'resource_path': 'configs'
            }
        }

    def get_arts(self):
        return [{'path': '{}/bin/dj_as_server'.format(self.server_target_path), 'dest': ''},
                {'path': '{}/bstr'.format(self.bstr_target_path), 'dest': ''},
                {'path': '{}/resource_bstr_loader'.format(self.bstr_resource_loader_target_path), 'dest': ''},
                {'path': '{}/resource_tar_callback'.format(self.resource_tar_callback_target_path), 'dest': ''}]

    def get_arts_source(self):
        return [{'path': '{}/configs/server_prod.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/server_testing.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/bstr_loader_config_prod.json'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/bstr_loader_config_testing.json'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/catboost_feature_extractors.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/components_general.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/components_general_for_tests.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/components_general_no_tests.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/components_prod.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/components_testing.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/experiments_general.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/experiments_prod.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/experiments_testing.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/shared_components_general.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/shared_components_prod.conf'.format(self.server_target_path),
                 'dest': 'configs'},
                {'path': '{}/configs/shared_components_testing.conf'.format(self.server_target_path),
                 'dest': 'configs'}]
