from sandbox import sdk2

assistant_releasers = [
    'deemonasd',
    'ivangromov',
    'jan-fazli',
    'karina-usm',
    'lavv17',
    'mike88',
    'robot-srch-releaser',
    'robot-testenv',
]


class ALISA_SKILLS_REC_BIN(sdk2.Resource):
    """
    Package for alisa skills recommendation service bin
    """
    releasable = True
    any_arch = True
    executable = True
    releasers = assistant_releasers
    arcadia_build_path = 'dj/services/alisa_skills/server/bin'


class ALISA_SKILLS_REC_BSTR(sdk2.Resource):
    """
    Package for alisa skills recommendation bstr
    """
    releasable = True
    any_arch = True
    executable = True
    releasers = assistant_releasers
    arcadia_build_path = 'tools/bstr'


class ALISA_SKILLS_REC_BSTR_RESOURCE_LOADER(sdk2.Resource):
    """
    Package for alisa skills recommendation bstr resource loader
    """
    releasable = True
    any_arch = True
    executable = True
    releasers = assistant_releasers
    arcadia_build_path = 'dj/tools/resource_loaders/resource_bstr_loader'


class ALISA_SKILLS_REC_RESOURSE_TAR_CALLBACK(sdk2.Resource):
    """
    Package for alisa skills recommendation resource tar callback
    """
    releasable = True
    any_arch = True
    executable = True
    releasers = assistant_releasers
    arcadia_build_path = 'dj/tools/resource_loaders/resource_tar_callback'


class ALISA_SKILLS_REC_CONFIGS(sdk2.Resource):
    """
    Package for alisa skills recommendation service configs
    """
    releasable = True
    any_arch = True
    executable = False
    releasers = assistant_releasers


class ALISA_SKILLS_REC_AMMO_OLD(sdk2.Resource):
    """
    Ammo from old DJ style logs
    """
    releasable = False
    any_arch = True
    executable = False
    releasers = assistant_releasers


class ALISA_SKILLS_REC_AMMO(sdk2.Resource):
    """
    Ammo from SkillRec Alice style binary logs
    """
    releasable = False
    any_arch = True
    executable = False
    releasers = assistant_releasers


class ALISA_SKILLS_REC_AMMO_RATIO(sdk2.Resource):
    """
    New to old SkillRec ammo ratio
    """
    releasable = False
    any_arch = True
    executable = False
    releasers = assistant_releasers


class ALISA_SKILLS_REC_INTERNAL_SKILLS_DATA_TAR(sdk2.Resource):
    """
    Internal skills data archive
    """
    releasable = False
    any_arch = True
    executable = False


class ALISA_SKILLS_REC_EXTERNAL_SKILLS_DATA_TAR(sdk2.Resource):
    """
    External skills data archive
    """
    releasable = False
    any_arch = True
    executable = False


class ALISA_SKILLS_REC_POSTROLL_PROFILES_SHARD(sdk2.Resource):
    """
    Postroll profiles shard
    """
    releasable = False
    any_arch = True
    executable = False
