# coding: utf-8

import datetime

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny


class AllazarevParameters(sdk2.Parameters):
    release_labels = nanny.LabelsParameter2('nanny release labels')


class AllazarevResource(sdk2.Resource):
    """
    allazarev_resource
    """
    releasable = True
    any_arch = False
    releasers = ['allazarev']
    auto_backup = True


class BuildAllazarev(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
    Build allazarev.
    """
    Parameters = AllazarevParameters

    def on_execute(self):
        f = open('allazarev_resource.txt', 'w')
        f.write(datetime.datetime.now().strftime('%d-%m-%y_%H:%M:%S'))
        f.write('allazarev resource text')
        f.close()
        self.create_resource()

    def create_resource(self):
        AllazarevResource(self, 'allazarev resource', 'allazarev_resource.txt')
