from sandbox import sdk2


ALTAY_RELEASERS = [
    'tagrimar',
    'outlander',
    'pperm86',
    'ksjuchi',
    'zhvv117',
    'bezdna',
    'sobols',
    'robot-testenv',
    'alexbobkov',
    'ar7is7',
    'kan-bazhev',
    'ilyamukh',
    'gzagon',
    'aleksbalashov',
    'ibvfteh',
    'alexkupri',
    'robot-altay',
]


class AltayResourceBase(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    any_arch = True
    auto_backup = True
    calc_md5 = True
    executable = False
    releasable = True
    releasers = ALTAY_RELEASERS
    share = True
    ttl = 100


class AltayBinaries(AltayResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/sprav/altay/packages/binaries/ya.make
    """
    pass


class AltayJavaBinaries(AltayResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/sprav/altay/packages/java/pkg.json
    """
    pass


class AltayConfigs(AltayResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/sprav/altay/packages/configs/ya.make
    """
    pass


class AltayCmpy(AltayResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/sprav/altay/packages/cmpy/ya.make
    """
    pass


class AltayScripts(AltayResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/sprav/altay/packages/scripts/ya.make
    """
    pass


class AltayYqlScripts(AltayResourceBase):
    """
    Contains YQL scripts
    """
    pass


class AltayFormulaResource(AltayResourceBase):
    """
    Formula resources
    """
    ttl = 'inf'


class SnezhanaCaller(AltayResourceBase):
    """
    Snezhana caller package
    """
    pass


class SnezhanaScheduler(AltayResourceBase):
    """
    Snezhana scheduler binary
    """
    pass


class AltaySwaggerUi(sdk2.Resource):
    """
    Swagger UI static site with Altay API description
    """
    releasable = True
    releasers = ALTAY_RELEASERS
    executable = False
    any_arch = True
    ttl = "inf"
